package aspectEditor.aspectEditorUtils;
import java.util.jar.JarFile;
import java.util.*;
import java.io.*;
import edu.neu.ccs.demeter.aplib.*;
import edu.neu.ccs.demeter.*;
public abstract class SimpleStrategy extends Strategy {
  protected NameMap parsedNameMap;
  public NameMap get_parsedNameMap() { return parsedNameMap; }
  public void set_parsedNameMap(NameMap new_parsedNameMap) { parsedNameMap = new_parsedNameMap; }
  public SimpleStrategy() { super(); }
  public SimpleStrategy(NameMap parsedNameMap) {
    super();
    set_parsedNameMap(parsedNameMap);
  }
  public boolean isSimpleStrategy() { return true; }
  public Set getSourceNames() {
    return getAllNames(toSimpleStrategy().getSources());
  }
  public Set getTargetNames() {
    return getAllNames(toSimpleStrategy().getTargets());
  }
  public Set getAllNames(Collection nodes) {
    Set names = new LinkedHashSet();
    for (Iterator it = nodes.iterator(); it.hasNext();) {
      Collection nodeNames = toSimpleStrategy().getNames(it.next());
      if (nodeNames == null)
	return null;
      else
	names.addAll(nodeNames);
    }
    return Collections.unmodifiableSet(names);
  }
  void universal_trv0_bef(UniversalVisitor _v_) {
    super.universal_trv0_bef(_v_);
    ((UniversalVisitor) _v_).before(this);
  }

  void universal_trv0_aft(UniversalVisitor _v_) {
    ((UniversalVisitor) _v_).after(this);
    super.universal_trv0_aft(_v_);
  }

  void universal_trv0(UniversalVisitor _v_) {
    if (parsedNameMap != null) {
      ((UniversalVisitor) _v_).before_parsedNameMap(this, parsedNameMap);
      parsedNameMap.universal_trv0(_v_);
      ((UniversalVisitor) _v_).after_parsedNameMap(this, parsedNameMap);
    }
    super.universal_trv0(_v_);
  }

  void __trav_attachEnv_Strategy_trv(__V_Strategy_attachEnv __v0) {  }

  void __trav_toGraph_PathDirective_trv_bef(__V_PathDirective_toGraph __v0) {
    super.__trav_toGraph_PathDirective_trv_bef(__v0);
  }

  void __trav_toGraph_PathDirective_trv_aft(__V_PathDirective_toGraph __v0) {
    super.__trav_toGraph_PathDirective_trv_aft(__v0);
  }

  void __trav_toGraph_PathDirective_trv(__V_PathDirective_toGraph __v0) {
    if (parsedNameMap != null) {
      parsedNameMap.__trav_toGraph_PathDirective_trv(__v0);
    }
  }

}
