package aspectEditor.aspectEditorUtils;
import java.util.HashSet;
import java.util.Iterator;

import aspectEditor.editors.AspectEditor;
import edu.neu.ccs.demeter.aplib.TraversalException;
import edu.neu.ccs.demeter.aplib.TraversalGraph.EdgeSet;
import edu.neu.ccs.demeter.aplib.TraversalGraph.NodeSet;
import edu.neu.ccs.demeter.aplib.cd.ClassGraph;
class GraphNodeRegExp extends Simple {
	
	//get all nodes that begin with the regular expression provided by this object
	public void interpretExpression(SelectorL s, ClassGraph c) {
		edu.neu.ccs.demeter.dj.Strategy strat= new edu.neu.ccs.demeter.dj.Strategy("from * to *");
		HashSet nodesTraversed = new HashSet();
		HashSet nodesToHighlight = new HashSet();
		
		//first get all nodes traversed in "from * to *"
		try {
			edu.neu.ccs.demeter.aplib.TraversalGraph trav = new edu.neu.ccs.demeter.aplib.TraversalGraph(strat.toSimpleStrategy(),c.normalize());
			nodesTraversed = new HashSet(trav.getNodeSets());
		}
		catch(TraversalException e){
			AspectEditor.traversalViewer.setText(e.getMessage());
		}
		
		//now check to see if any of the nodes begin with the regexp value
		Iterator i = nodesTraversed.iterator();
		while(i.hasNext()){
			NodeSet currNodeset = (NodeSet)i.next();
			String currNodeSetName = currNodeset.getNode().toString();
			
			//if the name of the current node set begins with the value of the reg exp
			//add it to the nodesToHighlight 
			if(this.get_classname().toString().startsWith(currNodeSetName)){
				nodesToHighlight.add(currNodeset);
			}
		}
		//because regexp doesn't highlight edges, we give highlightStrategiesBinary an empty one
		HashSet blankEdgeSet = new HashSet();
		Main.highlightStrategiesBinary(c,nodesToHighlight,null);
	}
	
	protected ClassName classname;
	public ClassName get_classname() { return classname; }
	public void set_classname(ClassName new_classname) { classname = new_classname; }
	protected WildCard wildcard;
	public WildCard get_wildcard() { return wildcard; }
	public void set_wildcard(WildCard new_wildcard) { wildcard = new_wildcard; }
	public GraphNodeRegExp() { super(); }
	public GraphNodeRegExp(ClassName classname, WildCard wildcard) {
		super();
		set_classname(classname);
		set_wildcard(wildcard);
	}
	public static GraphNodeRegExp parse(java.io.Reader in) throws ParseException { return new Parser(in)._GraphNodeRegExp(); }
	public static GraphNodeRegExp parse(java.io.InputStream in) throws ParseException { return new Parser(in)._GraphNodeRegExp(); }
	public static GraphNodeRegExp parse(String s) {
		try { return parse(new java.io.StringReader(s)); }
		catch (ParseException e) {
			throw new RuntimeException(e.toString());
		}
	}
	void universal_trv0_bef(UniversalVisitor _v_) {
		super.universal_trv0_bef(_v_);
		((UniversalVisitor) _v_).before(this);
	}
	
	void universal_trv0_aft(UniversalVisitor _v_) {
		((UniversalVisitor) _v_).after(this);
		super.universal_trv0_aft(_v_);
	}
	
	void universal_trv0(UniversalVisitor _v_) {
		universal_trv0_bef(_v_);
		((UniversalVisitor) _v_).before_classname(this, classname);
		classname.universal_trv0(_v_);
		((UniversalVisitor) _v_).after_classname(this, classname);
		((UniversalVisitor) _v_).before_wildcard(this, wildcard);
		wildcard.universal_trv0(_v_);
		((UniversalVisitor) _v_).after_wildcard(this, wildcard);
		super.universal_trv0(_v_);
		universal_trv0_aft(_v_);
	}
	
}
