package aspectEditor.aspectEditorUtils;
import java.util.jar.JarFile;
import java.util.*;
import java.io.*;
import edu.neu.ccs.demeter.aplib.*;
import edu.neu.ccs.demeter.*;
class PrintVisitor extends UniversalVisitor {
  protected int indent;
  public int get_indent() { return indent; }
  public void set_indent(int new_indent) { indent = new_indent; }
  protected boolean needSpace;
  public boolean get_needSpace() { return needSpace; }
  public void set_needSpace(boolean new_needSpace) { needSpace = new_needSpace; }
  public PrintVisitor() { super(); }
  public PrintVisitor(int indent, boolean needSpace) {
    super();
    set_indent(indent);
    set_needSpace(needSpace);
  }

    protected java.io.PrintWriter out = new java.io.PrintWriter(System.out, true);
    java.io.PrintWriter get_out()             { return out; }
    void set_out(java.io.PrintWriter new_out) { out = new_out; }
    PrintVisitor(java.io.PrintWriter out)     { set_out(out); }
    PrintVisitor(java.io.PrintStream out)
      { set_out(new java.io.PrintWriter(out, true)); }
  
  public void finish() { out.flush(); }
  protected void space() {
    if (needSpace) out.print(" ");
    needSpace = false;
  }
  public void before_classdictionaryname(ClassDictionaryL source, ClassDictionaryName dest) {
    space();
    out.print("aspect");
    needSpace = true;
    out.print("(");
    needSpace = false;
    space();
    out.print("ClassDictionary");
    needSpace = true;
    out.print(")");
    needSpace = false;
  }
  public void before_ident(ClassDictionaryName source, Ident dest) {
    space();
    out.print(source.get_ident());
    needSpace = true;
  }
  public void before_ident(TraversalName source, Ident dest) {
    space();
    out.print(source.get_ident());
    needSpace = true;
  }
  public void before_traversalname(SelectorL source, TraversalName dest) {
    space();
    out.print("aspect");
    needSpace = true;
    out.print("(");
    needSpace = false;
    space();
    out.print("Traversal");
    needSpace = true;
    out.print(")");
    needSpace = false;
  }
  public void before_strategydef_list(SelectorL source, StrategyDef_List dest) {
    out.print("{");
    needSpace = false;
  }
  public void before_selectorname(SelectorL source, SelectorName dest) {
    space();
    out.print("declare");
    needSpace = true;
    space();
    out.print("chosen");
    needSpace = true;
    space();
    out.print("selector:");
    needSpace = false;
  }
  public void after_selectorname(SelectorL source, SelectorName dest) {
    out.print(";");
    needSpace = false;
  }
  public void before_classdictionaryname(SelectorL source, ClassDictionaryName dest) {
    space();
    out.print("declare");
    needSpace = true;
    space();
    out.print("chosen");
    needSpace = true;
    space();
    out.print("class");
    needSpace = true;
    space();
    out.print("dictionary:");
    needSpace = false;
  }
  public void after_classdictionaryname(SelectorL source, ClassDictionaryName dest) {
    out.print(";");
    needSpace = false;
  }
  public void after(SelectorL host) {
    out.print("}");
    needSpace = false;
  }
  public void before_strategyname(StrategyDef source, StrategyName dest) {
    space();
    out.print("declare");
    needSpace = true;
    space();
    out.print("strategy");
    needSpace = true;
    out.print(":");
    needSpace = false;
  }
  public void before_strategyexpression(StrategyDef source, StrategyExpression dest) {
    out.print(":");
    needSpace = false;
  }
  public void after_strategyexpression(StrategyDef source, StrategyExpression dest) {
    out.print(";");
    needSpace = false;
  }
  public void before_nodesubsetname(NodeSubsetDef source, NodeSubsetName dest) {
    space();
    out.print("declare");
    needSpace = true;
    space();
    out.print("node");
    needSpace = true;
    space();
    out.print("set");
    needSpace = true;
    out.print(":");
    needSpace = false;
  }
  public void before_nodesubsetexpression(NodeSubsetDef source, NodeSubsetExpression dest) {
    out.print(":");
    needSpace = false;
  }
  public void after_nodesubsetexpression(NodeSubsetDef source, NodeSubsetExpression dest) {
    out.print(";");
    needSpace = false;
  }
  public void before_ident(SelectorName source, Ident dest) {
    space();
    out.print(source.get_ident());
    needSpace = true;
  }
  public void before_text(ClassDict source, Text dest) {
    space();
    out.print("{{" + source.get_text() + "}" + "}");
    needSpace = true;
  }
  public void before(Union host) {
    space();
    out.print("or");
    needSpace = true;
  }
  public void before(Intersection host) {
    space();
    out.print("and");
    needSpace = true;
  }
  public void before(Complement host) {
    out.print("!");
    needSpace = false;
  }
  public void before_strategyname(GraphNodes source, StrategyName dest) {
    space();
    out.print("nodes");
    needSpace = true;
  }
  public void before_classname(GraphNodeRegExp source, ClassName dest) {
    space();
    out.print("regexp");
    needSpace = true;
  }
  public void before(WildCard host) {
    out.print("*");
    needSpace = false;
  }
  public void before_parsedNameMap(SimpleStrategy source, NameMap dest) {
    space();
    out.print("with");
    needSpace = true;
    out.print(" ");
    needSpace = false;
  }
  public void before_edges(StrategyGraph source, SGEdge_SList dest) {
    out.print("{");
    needSpace = false;
    out.println();
    for (int i = 0; i < indent; i++) out.print("\t");
    needSpace = false;
    out.print("\t");
    indent++;
    needSpace = false;
  }
  public void after_edges(StrategyGraph source, SGEdge_SList dest) {
    indent--;
    out.println();
    for (int i = 0; i < indent; i++) out.print("\t");
    needSpace = false;
    out.print("}");
    needSpace = false;
  }
  public void after_sourcemarker(SGEdge source, SourceMarker dest) {
    out.print(" ");
    needSpace = false;
  }
  public void after_source(SGEdge source, GlobSpec dest) {
    out.print(" ");
    needSpace = false;
    out.print("->");
    needSpace = false;
    out.print(" ");
    needSpace = false;
  }
  public void after_targetmarker(SGEdge source, TargetMarker dest) {
    out.print(" ");
    needSpace = false;
  }
  public void before_constraint(SGEdge source, NegativeConstraint dest) {
    out.print(" ");
    needSpace = false;
  }
  public void before(SourceMarker host) {
    space();
    out.print("source:");
    needSpace = false;
  }
  public void before(TargetMarker host) {
    space();
    out.print("target:");
    needSpace = false;
  }
  public void before_constraint(PathDirective source, NegativeConstraint dest) {
    out.print(" ");
    needSpace = false;
  }
  public void before_target(PathDirective source, TargetDirective dest) {
    out.print(" ");
    needSpace = false;
  }
  public void before_sources(SourceDirective source, ClassGlobSpec dest) {
    out.print(" ");
    needSpace = false;
  }
  public void before(From host) {
    space();
    out.print("from");
    needSpace = true;
  }
  public void before_constraint(PathSegment source, NegativeConstraint dest) {
    out.print(" ");
    needSpace = false;
  }
  public void before_glob(Constraint source, GlobSpec dest) {
    out.print(" ");
    needSpace = false;
  }
  public void before(Through host) {
    space();
    out.print("through");
    needSpace = true;
  }
  public void before(Via host) {
    space();
    out.print("via");
    needSpace = true;
  }
  public void before(Bypassing host) {
    space();
    out.print("bypassing");
    needSpace = true;
  }
  public void before(OnlyThrough host) {
    space();
    out.print("only-through");
    needSpace = true;
  }
  public void before_targets(TargetDirective source, ClassGlobSpec dest) {
    out.print(" ");
    needSpace = false;
  }
  public void before(To host) {
    space();
    out.print("to");
    needSpace = true;
  }
  public void before(ToStop host) {
    space();
    out.print("to-stop");
    needSpace = true;
  }
  public void before_first(StrategyCombination source, Strategy dest) {
    out.print("(");
    needSpace = false;
  }
  public void before_rest(StrategyCombination source, Strategy_Commalist dest) {
    out.print(",");
    needSpace = false;
    out.print(" ");
    needSpace = false;
  }
  public void after_rest(StrategyCombination source, Strategy_Commalist dest) {
    out.print(")");
    needSpace = false;
  }
  public void before(Join host) {
    space();
    out.print("join");
    needSpace = true;
  }
  public void before(Merge host) {
    space();
    out.print("merge");
    needSpace = true;
  }
  public void before(Intersect host) {
    space();
    out.print("intersect");
    needSpace = true;
  }
  public void before_ident(StrategyReference source, Ident dest) {
    space();
    out.print(source.get_ident());
    needSpace = true;
  }
  public void before(NameMap host) {
    out.print("{");
    needSpace = false;
    out.print(" ");
    needSpace = false;
  }
  public void after_bindings(NameMap source, NameBinding_Commalist dest) {
    out.print(" ");
    needSpace = false;
  }
  public void after(NameMap host) {
    out.print("}");
    needSpace = false;
  }
  public void before_cgNames(NameBinding source, ClassGlobSpec dest) {
    out.print("=");
    needSpace = false;
  }
  public void before(GlobSet host) {
    out.print("{");
    needSpace = false;
    out.print(" ");
    needSpace = false;
  }
  public void after_globs(GlobSet source, Glob_Commalist dest) {
    out.print(" ");
    needSpace = false;
  }
  public void after(GlobSet host) {
    out.print("}");
    needSpace = false;
  }
  public void before_source(PartGlob source, SourceGlob dest) {
    out.print("->");
    needSpace = false;
    out.print(" ");
    needSpace = false;
  }
  public void before_name(PartGlob source, PartNameGlob dest) {
    out.print(",");
    needSpace = false;
  }
  public void before_target(PartGlob source, TargetGlob dest) {
    out.print(",");
    needSpace = false;
  }
  public void before_source(SubclassGlob source, SourceGlob dest) {
    out.print("=>");
    needSpace = false;
    out.print(" ");
    needSpace = false;
  }
  public void before_target(SubclassGlob source, TargetGlob dest) {
    out.print(",");
    needSpace = false;
  }
  public void before_source(SuperclassGlob source, SourceGlob dest) {
    out.print(":>");
    needSpace = false;
    out.print(" ");
    needSpace = false;
  }
  public void before_target(SuperclassGlob source, TargetGlob dest) {
    out.print(",");
    needSpace = false;
  }
  public void before(AnyClass host) {
    out.print("*");
    needSpace = false;
  }
  public void before(AnyPart host) {
    out.print("*");
    needSpace = false;
  }
  public void before_globs(ClassGlobSet source, ClassGlob_Commalist dest) {
    out.print("{");
    needSpace = false;
    out.print(" ");
    needSpace = false;
  }
  public void after_globs(ClassGlobSet source, ClassGlob_Commalist dest) {
    out.print(" ");
    needSpace = false;
    out.print("}");
    needSpace = false;
  }
  public void before_name(PartName source, Ident dest) {
    space();
    out.print(source.get_name());
    needSpace = true;
  }
  public void before_name(StrategyName source, Ident dest) {
    space();
    out.print(source.get_name());
    needSpace = true;
  }
  public void before_name(NodeSubsetName source, Ident dest) {
    space();
    out.print(source.get_name());
    needSpace = true;
  }
  public void before_indent(PrintVisitor source, int dest) {
    space();
    out.print(source.get_indent());
    needSpace = true;
  }
  public void before_needSpace(PrintVisitor source, boolean dest) {
    space();
    out.print(source.get_needSpace());
    needSpace = true;
  }
  public void before_copy(CopyVisitor source, Object dest) {
    space();
    out.print(source.get_copy());
    needSpace = true;
  }
  public void before_is_equal(SubgraphVisitor source, boolean dest) {
    space();
    out.print(source.get_is_equal());
    needSpace = true;
  }
  public void before_is_equal(EqualVisitor source, boolean dest) {
    space();
    out.print(source.get_is_equal());
    needSpace = true;
  }
  public void before_indent(DisplayVisitor source, int dest) {
    space();
    out.print(source.get_indent());
    needSpace = true;
  }
  public void before_indent(TraceVisitor source, int dest) {
    space();
    out.print(source.get_indent());
    needSpace = true;
  }
  public void before_first(NodeSubsetExpression_PCList source, Nonempty_NodeSubsetExpression_PCList dest) {
    out.print("(");
    needSpace = false;
  }
  public void after_first(NodeSubsetExpression_PCList source, Nonempty_NodeSubsetExpression_PCList dest) {
    out.print(")");
    needSpace = false;
  }
  public void before_first(ClassName_BCList source, Nonempty_ClassName_BCList dest) {
    out.print("{");
    needSpace = false;
  }
  public void after_first(ClassName_BCList source, Nonempty_ClassName_BCList dest) {
    out.print("}");
    needSpace = false;
  }
  public void before_it(Nonempty_Name source, Ident dest) {
    space();
    out.print(source.get_it());
    needSpace = true;
  }
  public void before_next(Nonempty_Name source, Nonempty_Name dest) {
    out.print(".");
    needSpace = false;
  }
  public void before_next(Nonempty_AspectLanguage_List source, Nonempty_AspectLanguage_List dest) {
    out.print(" ");
    needSpace = false;
  }
  public void before_next(Nonempty_StrategyDef_List source, Nonempty_StrategyDef_List dest) {
    out.print(" ");
    needSpace = false;
  }
  public void before_next(Nonempty_NodeSubsetDef_List source, Nonempty_NodeSubsetDef_List dest) {
    out.print(" ");
    needSpace = false;
  }
  public void before_next(Nonempty_NodeSubsetExpression_PCList source, Nonempty_NodeSubsetExpression_PCList dest) {
    out.print(",");
    needSpace = false;
  }
  public void before_next(Nonempty_ClassName_BCList source, Nonempty_ClassName_BCList dest) {
    out.print(",");
    needSpace = false;
  }
  public void before_next(Nonempty_SGEdge_SList source, Nonempty_SGEdge_SList dest) {
    out.println();
    for (int i = 0; i < indent; i++) out.print("\t");
    needSpace = false;
  }
  public void before_next(Nonempty_PathSegment_List source, Nonempty_PathSegment_List dest) {
    out.print(" ");
    needSpace = false;
  }
  public void before_next(Nonempty_Strategy_Commalist source, Nonempty_Strategy_Commalist dest) {
    out.print(",");
    needSpace = false;
    out.print(" ");
    needSpace = false;
  }
  public void before_next(Nonempty_NameBinding_Commalist source, Nonempty_NameBinding_Commalist dest) {
    out.print(",");
    needSpace = false;
    out.print(" ");
    needSpace = false;
  }
  public void before_next(Nonempty_Glob_Commalist source, Nonempty_Glob_Commalist dest) {
    out.print(",");
    needSpace = false;
    out.print(" ");
    needSpace = false;
  }
  public void before_next(Nonempty_ClassGlob_Commalist source, Nonempty_ClassGlob_Commalist dest) {
    out.print(",");
    needSpace = false;
    out.print(" ");
    needSpace = false;
  }
  void universal_trv0_bef(UniversalVisitor _v_) {
    super.universal_trv0_bef(_v_);
  }

  void universal_trv0_aft(UniversalVisitor _v_) {
    super.universal_trv0_aft(_v_);
  }

  void universal_trv0(UniversalVisitor _v_) {
    universal_trv0_bef(_v_);
    super.universal_trv0(_v_);
    universal_trv0_aft(_v_);
  }

}
